/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.Set;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.priv.ChannelException;
import oracle.cluster.priv.ChannelFactory;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RootAutomationUtility
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    static RootUserCredentials s_rootCreds = null;

    public static VerificationResultSet checkRootPassword(String[] nodeList, String password) throws VerificationException {
        return RootAutomationUtility.checkRootPassword(nodeList, password, 1000);
    }

    public static VerificationResultSet checkRootPassword(String[] nodeList, String password, int timeout) throws VerificationException {
        Trace.out((String)"Entered checkRootPassword");
        Assert.assertNodes(nodeList);
        Assert.assertPassword(password);
        RootAutomationUtility.setRootExecutionInfo(ConfigurationSetup.ConfigMethod.ROOT, Utils.getRootUserName(), password, null);
        ResultSet rs = new ResultSet();
        try {
            ChannelFactory cf = ChannelFactory.getInstance();
            cf.checkRootPassword(nodeList, password, timeout);
            rs.addResult(nodeList, 1);
        }
        catch (ChannelException ce) {
            Trace.out((String)("Received ChannelException in checkRootPassword" + ce.getMessage()));
            rs.addResult(nodeList, 2);
            String errMsg = ce.getMessage();
            ErrorDescription ed = new ErrorDescription(errMsg);
            rs.addErrorDescription(ed);
        }
        catch (CompositeOperationException coe) {
            if (coe.getMessage() != null) {
                Trace.out((String)("Received CompositeOperationException  " + coe.getMessage()));
            }
            try {
                Set compositeErrorSet = coe.getOperationIdentifier();
                for (Object obj : compositeErrorSet) {
                    String errMsg;
                    String node = (String)obj;
                    Result r = new Result(node);
                    NativeResult nativeResult = coe.getNativeResult(obj);
                    int osErrorCode = nativeResult.getOSErrCode();
                    if (nativeResult.getOSErrCode() <= 0 && coe.getStatus(obj) == CompositeOperationException.Status.SUCCESS) {
                        Trace.out((String)("success on node : " + node));
                        rs.addResult(node, 1);
                        continue;
                    }
                    if (coe.getStatus(obj) == CompositeOperationException.Status.FAILURE) {
                        Trace.out((String)("failed on node : " + node));
                        rs.addResult(node, 3);
                        errMsg = s_gMsgBundle.getMessage("11301", true, (Object[])new String[]{VerificationUtil.getRootUsername(), node}) + LSEP + coe.getMessage();
                        String[] resultStringArr = nativeResult.getResultString();
                        if (resultStringArr != null) {
                            errMsg = errMsg + LSEP + VerificationUtil.strArr2String(resultStringArr);
                        }
                        ErrorDescription ed = new ErrorDescription(errMsg);
                        rs.addErrorDescription(node, ed);
                        continue;
                    }
                    Trace.out((String)("command failed on node : " + node));
                    rs.addResult(node, 2);
                    errMsg = coe.getException(obj).getMessage();
                    ErrorDescription ed = new ErrorDescription(errMsg);
                    rs.addErrorDescription(node, ed);
                }
            }
            catch (NoSuchIdentifierException ne) {
                Trace.out((String)ne.getMessage());
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            rs.traceResultSet("=== checkRootPassword results ===");
        }
        return rs;
    }

    public static VerificationResultSet checkSudoExistence(String[] nodeList, String sudoLocation, String username, String password) throws VerificationException {
        Assert.assertNodes(nodeList);
        Assert.assertLocation(sudoLocation);
        RootAutomationUtility.setRootExecutionInfo(ConfigurationSetup.ConfigMethod.SUDO, username, password, sudoLocation);
        ResultSet rs = new ResultSet();
        try {
            ChannelFactory cf = ChannelFactory.getInstance();
            RootUserCredentials credentials = RootAutomationUtility.getRootExecutionInfo();
            cf.checkSudoExistence(nodeList, credentials.getSudoPbrunLocation(), credentials.getRootUserCredentials().getUsername(), credentials.getRootUserCredentials().getPassword());
            rs.addResult(nodeList, 1);
        }
        catch (ChannelException ce) {
            Trace.out((String)("Received ChannelException  in checkSudoExistence" + ce.getMessage()));
            rs.addResult(nodeList, 2);
            String errMsg = ce.getMessage();
            ErrorDescription ed = new ErrorDescription(errMsg);
            rs.addErrorDescription(ed);
        }
        catch (CompositeOperationException coe) {
            Trace.out((String)("Received CompositeOperationException  " + coe.getMessage()));
            try {
                Set compositeErrorSet = coe.getOperationIdentifier();
                for (Object obj : compositeErrorSet) {
                    ErrorDescription ed;
                    String errMsg;
                    String node = (String)obj;
                    Result r = new Result(node);
                    NativeResult nativeResult = coe.getNativeResult(obj);
                    if (nativeResult.getOSErrCode() == 0 && coe.getStatus(obj) == CompositeOperationException.Status.SUCCESS) {
                        Trace.out((String)("command succeeded on node :" + node));
                        rs.addResult(node, 1);
                        continue;
                    }
                    if (coe.getStatus(obj) == CompositeOperationException.Status.FAILURE) {
                        Trace.out((String)("sudo from location " + sudoLocation + " cannot be executed on node : " + node));
                        rs.addResult(node, 3);
                        errMsg = s_gMsgBundle.getMessage("11302", true, (Object[])new String[]{sudoLocation, node});
                        ed = new ErrorDescription(errMsg);
                        rs.addErrorDescription(node, ed);
                        continue;
                    }
                    rs.addResult(node, 2);
                    errMsg = coe.getException(obj).getMessage();
                    ed = new ErrorDescription(errMsg);
                    rs.addErrorDescription(node, ed);
                }
            }
            catch (NoSuchIdentifierException ne) {
                Trace.out((String)ne.getMessage());
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            rs.traceResultSet("=== checkSudoExistence results ===");
        }
        return rs;
    }

    public static VerificationResultSet checkSudoExecution(String[] nodeList, String sudoLocation, String username, String password) throws VerificationException {
        return RootAutomationUtility.checkSudoExecution(nodeList, sudoLocation, username, password, 1000);
    }

    public static VerificationResultSet checkSudoExecution(String[] nodeList, String sudoLocation, String username, String password, int timeout) throws VerificationException {
        Trace.out((String)"Entered checkSudoExecution");
        Assert.assertNodes(nodeList);
        Assert.assertLocation(sudoLocation);
        Assert.assertUser(username);
        Assert.assertPassword(password);
        RootAutomationUtility.setRootExecutionInfo(ConfigurationSetup.ConfigMethod.SUDO, username, password, sudoLocation);
        ResultSet rs = new ResultSet();
        ChannelFactory cf = null;
        try {
            cf = ChannelFactory.getInstance();
            RootUserCredentials credentials = RootAutomationUtility.getRootExecutionInfo();
            cf.checkSudoExecution(nodeList, credentials.getSudoPbrunLocation(), credentials.getRootUserCredentials().getUsername(), credentials.getRootUserCredentials().getPassword(), timeout);
            rs.addResult(nodeList, 1);
        }
        catch (ChannelException ce) {
            Trace.out((String)("Received ChannelException  in checkSudoExistence" + ce.getMessage()));
            rs.addResult(nodeList, 2);
            String errMsg = ce.getMessage();
            ErrorDescription ed = new ErrorDescription(errMsg);
            rs.addErrorDescription(ed);
        }
        catch (CompositeOperationException coe) {
            Trace.out((String)("Received CompositeOperationException  " + coe.getMessage()));
            try {
                Set compositeErrorSet = coe.getOperationIdentifier();
                for (Object obj : compositeErrorSet) {
                    ErrorDescription ed;
                    String errMsg;
                    String node = (String)obj;
                    NativeResult nativeResult = coe.getNativeResult(obj);
                    int osErrorCode = nativeResult.getOSErrCode();
                    if (coe.getStatus(obj) == CompositeOperationException.Status.SUCCESS) {
                        if (osErrorCode == 0) {
                            Trace.out((String)("execution successful on node: " + node));
                            rs.addResult(node, 1);
                            continue;
                        }
                        rs.addResult(node, 2);
                        errMsg = coe.getMessage() + LSEP + VerificationUtil.strArr2String(nativeResult.getOutputString(), LSEP);
                        ed = new ErrorDescription(errMsg);
                        rs.addErrorDescription(node, ed);
                        continue;
                    }
                    if (coe.getStatus(obj) == CompositeOperationException.Status.FAILURE) {
                        rs.addResult(node, 3);
                        ErrorDescription ed2 = new ErrorDescription(s_gMsgBundle.getMessage("11303", true, (Object[])new String[]{node}));
                        rs.addErrorDescription(node, ed2);
                        continue;
                    }
                    if (coe.getStatus(obj) != CompositeOperationException.Status.EXCEPTION) continue;
                    rs.addResult(node, 2);
                    errMsg = coe.getException(obj).getMessage();
                    ed = new ErrorDescription(errMsg);
                    rs.addErrorDescription(node, ed);
                }
            }
            catch (NoSuchIdentifierException ne) {
                Trace.out((String)ne.getMessage());
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            rs.traceResultSet("=== checkSudoExecution results ===");
        }
        return rs;
    }

    public static VerificationResultSet checkPbrunExistence(String[] nodeList, String pbLocation, String username, String password) throws VerificationException {
        Assert.assertNodes(nodeList);
        Assert.assertLocation(pbLocation);
        RootAutomationUtility.setRootExecutionInfo(ConfigurationSetup.ConfigMethod.PBRUN, username, password, pbLocation);
        ResultSet rs = new ResultSet();
        for (String node : nodeList) {
            rs.addResult(node, 1);
        }
        return rs;
    }

    public static VerificationResultSet checkPbrunExecution(String[] nodeList, String pblocation, String username, String password) throws VerificationException {
        return RootAutomationUtility.checkPbrunExecution(nodeList, pblocation, username, password, 1000);
    }

    public static VerificationResultSet checkPbrunExecution(String[] nodeList, String pbLocation, String username, String password, int timeout) throws VerificationException {
        Assert.assertNodes(nodeList);
        Assert.assertLocation(pbLocation);
        Assert.assertUser(username);
        Assert.assertPassword(password);
        RootAutomationUtility.setRootExecutionInfo(ConfigurationSetup.ConfigMethod.PBRUN, username, password, pbLocation);
        ResultSet rs = new ResultSet();
        for (String node : nodeList) {
            rs.addResult(node, 1);
        }
        return rs;
    }

    private static void setRootExecutionInfo(ConfigurationSetup.ConfigMethod execMode, String username, String password, String location) {
        RootAutomationUtility.setRootExecutionInfo(execMode, new UserInfo(username, password), location);
    }

    public static void setRootExecutionInfo(ConfigurationSetup.ConfigMethod execMode, UserInfo creds, String location) {
        ConfigurationSetup.ConfigMethod method = execMode == ConfigurationSetup.ConfigMethod.ROOT ? ConfigurationSetup.ConfigMethod.ROOT : (execMode == ConfigurationSetup.ConfigMethod.SUDO ? ConfigurationSetup.ConfigMethod.SUDO : ConfigurationSetup.ConfigMethod.PBRUN);
        if (method == ConfigurationSetup.ConfigMethod.ROOT) {
            s_rootCreds = new RootUserCredentials(method, creds);
        } else {
            if (!VerificationUtil.isStringGood(location)) {
                location = VerificationUtil.getSudoPbrunLocationFromConfigFile(method);
            }
            Trace.out((String)("The location for sudo/pbrun is " + location));
            VerificationLogData.logInfo("The location for sudo/pbrun is " + location);
            s_rootCreds = new RootUserCredentials(method, creds, location);
        }
    }

    public static RootUserCredentials getRootExecutionInfo() throws VerificationException {
        if (s_rootCreds == null) {
            throw new VerificationException("11304");
        }
        return s_rootCreds;
    }

    public static boolean isRootExecutionConfigured() {
        return s_rootCreds != null;
    }

    public static void readUserCredentialsCLI(ConfigurationSetup.ConfigMethod currConfigMethod, String sudoPbrunLocPath, String userName) throws ConsoleUtilException, VerificationException {
        String user = null;
        if (currConfigMethod == ConfigurationSetup.ConfigMethod.SUDO || currConfigMethod == ConfigurationSetup.ConfigMethod.PBRUN) {
            if (!VerificationUtil.isStringGood(userName)) {
                throw new VerificationException(s_gMsgBundle.getMessage("4002", false, (Object[])new String[]{currConfigMethod.toString()}));
            }
            user = userName;
        } else {
            user = VerificationUtil.isStringGood(userName) ? userName : ConfigurationSetup.ConfigMethod.ROOT.toString().toLowerCase();
        }
        ConsoleUtil console = new ConsoleUtil();
        String password = new String(console.readPassword(s_gMsgBundle.getMessage("9002", false, (Object[])new String[]{currConfigMethod.toString()})));
        Assert.assertInputParam(password, currConfigMethod.toString() + " password");
        RootAutomationUtility.setRootExecutionInfo(currConfigMethod, new UserInfo(user, password), sudoPbrunLocPath);
    }
}

